CommonTriggers = 
{
	end_trigger = function(trigger_id, time)
		local trigger = Triggers[trigger_id]
		
		if (trigger.active == true) then
		
			if (CUR_MISSION.KillTime == nil) then
				CUR_MISSION.KillTime = time
			end
			
			log(trigger_id, "KillTime:", CUR_MISSION.KillTime, "Time:", time)
			
			if ((time - CUR_MISSION.KillTime) > 5) then
				combatResults(CUR_MISSION.Name, false)
				
				Sectors[CUR_MISSION.Name].onEnd()
				Triggers[trigger_id].active = false
				
				showMessageBox("all_mercs_are_dead", OK, SMALL)
				finishMission(false)
			end
		end
	end,
	--
	kill_watcher = function(trigger_id, time)
		if not(isGameInRT()) then
		
			local check = function(index, force)
				service.checkPlayerUnits(force)
			end

			local mission_forces = { getMissionPlayers(CUR_MISSION.Name) }
			table.foreach(mission_forces, check)
			--table.foreach(CUR_MISSION.Forces, service.checkPlayerUnits)
		end
		--Sectors[CUR_MISSION.Name].onKill()
	end,
	--
	quest_watcher = function(trigger_id, time)
		local trigger = Triggers[trigger_id]
		if (trigger.active == true) then
			questWatcher[CUR_MISSION.Name].update()
		end
	end,
	--
	center_point = function(trigger_id, time)
		local trigger = Triggers[trigger_id]
		if ( (trigger.active == true) and (isGameInRT() == true) ) then
			log(trigger_id, "Active", "RT")
			if (BATTLE_DATA.Enabled == true) then
				local units_owner = BATTLE_DATA.Attacker
				local entrance = BATTLE_DATA.Entrance
				local units = deepcopy(BATTLE_DATA.AttackingUnits)
				local x = trigger.position.x
				local y = trigger.position.y
				local z = trigger.position.z
				local f = trigger.position.f
				
				log(trigger_id, units_owner, entrance, x, y, z, f)
				
				local command = function(unit, done)
					if ( healthOK(unit) and (done == false) ) then
						if ( (trigger_utility.isPersonPresent(trigger_id, unit) == true) and canIssueOrder(unit) and idle(unit) ) then
							log(trigger_id, unit, "in trigger")
							BATTLE_DATA.AttackingUnits[unit] = true
							stop(unit)
							addRotate(unit, x, y, z)
							Humans[unit].busy = 2
							executeOrders(unit)
						elseif ( canIssueOrder(unit) and idle(unit) ) then
							log(trigger_id, "Commanding", unit)
							local rx, ry, rz = service.randomPointAroundPoint(x, y, z, trigger.effect_radius)
							local ix, iy, iz = service.pointAlongPointToPersonLine(rx, ry, rz, unit, 10)
							addSmartMove(unit, "run", ix, iy, iz, f)
							Humans[unit].busy = 2
							executeOrders(unit)
						end
					end
				end
				
				table.foreach(units, command)
				log(trigger_id, "DONE")
			else
				Triggers[trigger_id].active = false
			end
		end
	end,
}
